// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler SourceSampler: register(s0);
sampler HSmallSampler: register(s2);
float4 srcConsts : register(c0);
float4 dstConsts : register(c1);
#define srcSize (srcConsts.xy)
#define srcPixSize (srcConsts.zw)
#define dstSize (dstConsts.xy)
#define dstPixSize (dstConsts.zw)
#define factor (dstSize.x / srcSize.x)
#define taps 1
#define sqr(value) ((value)*(value))
#define getSrcY(pos) (ConvertSpace(ConvertLight(tex2Dlod(SourceSampler, float4(pos, tex.y, 0, 0)).rgb)))
// #define ConvertLight(pix) (pix)
// #define ConvertSpace(pix) (pix)

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float hsmall = ConvertSpace(tex2D(HSmallSampler, tex).rgb);
  float result = 0;
  float weightSum = 0;
  int low  = ceil ((tex.x - taps * dstPixSize.x) * srcSize.x - 0.5);
  int high = floor((tex.x + taps * dstPixSize.x) * srcSize.x - 0.5);
  [loop] [fastopt] for (int k = low; k <= high; k++)
  {
    float pos    = srcPixSize.x * (k + 0.5);
    float offset = abs((tex.x - pos) * dstSize.x);
    float weight = saturate(0.5 + (0.5 - abs(offset)) / factor);
    result += weight * sqr(getSrcY(pos) - hsmall);
    weightSum += weight;
  }
  return float4(hsmall, result / weightSum, 0, 0);
}
